<?php
session_start();

// Adminin giriş edib-etmədiyini yoxlayırıq
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: admin_login.html");
    exit();
}

$file = 'data.json';
$data = [];
if (file_exists($file)) {
    $json_data = file_get_contents($file);
    $data = json_decode($json_data, true);
}
?>
<!DOCTYPE html>
<html lang="az">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Paneli</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <h1>Admin Paneli - İştirakçı Siyahısı</h1>
        <div class="admin-links">
            <a href="list.php" target="_blank">Sayta Bax</a>
            <a href="logout.php">Çıxış</a>
        </div>
        <table>
            <thead>
                <tr>
                    <th>Ad</th>
                    <th>Soyad</th>
                    <th>Şirkət Adı</th>
                    <th>Hədiyyə İstəyi</th>
                    <th>Məktublar</th>
                    <th>Əməliyyat</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if (!empty($data)) {
                    foreach ($data as $index => $entry) {
                        echo "<tr>";
                        echo "<td>" . htmlspecialchars($entry['name']) . "</td>";
                        echo "<td>" . htmlspecialchars($entry['surname']) . "</td>";
                        echo "<td>" . htmlspecialchars($entry['company']) . "</td>";
                        echo "<td>" . htmlspecialchars($entry['wish']) . "</td>";
                        echo "<td>";
                        // Main letter
                        if (!empty($entry['letter'])) {
                            echo "<strong>Öz Secret Santa'sına:</strong><br>" . htmlspecialchars($entry['letter']);
                        }
                        // Special letters
                        if (!empty($entry['special_letters'])) {
                            echo "<br><br><strong>Digər şəxslərə məktublar:</strong><ul>";
                            foreach ($entry['special_letters'] as $special_letter) {
                                echo "<li><strong>" . htmlspecialchars($special_letter['name']) . ":</strong> " . htmlspecialchars($special_letter['letter']) . "</li>";
                            }
                            echo "</ul>";
                        }
                        echo "</td>";
                        echo "<td><a href='delete.php?index=" . $index . "' onclick='return confirm(\"Bu iştirakçını silmək istədiyinizə əminsiniz?\");'>Sil</a></td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='6'>Heç bir iştirakçı qeydiyyatdan keçməyib.</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
    <audio id="background-music" src="music.mp3" loop></audio>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Music
            var music = document.getElementById('background-music');
            music.volume = 0.3; // Səs səviyyəsini tənzimləyin
            var promise = music.play();
            if (promise !== undefined) {
                promise.then(_ => {}).catch(error => {
                    document.body.addEventListener('click', () => music.play(), { once: true });
                });
            }
        });
    </script>
</body>
</html>