<?php
session_start();

// Adminin giriş edib-etmədiyini yoxlayırıq
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: admin_login.html");
    exit();
}

if (isset($_GET['index'])) {
    $index_to_delete = (int)$_GET['index'];
    $file = 'data.json';

    if (file_exists($file)) {
        $json_data = file_get_contents($file);
        $data = json_decode($json_data, true);

        // İndeksin mövcud olub-olmadığını yoxlayırıq
        if (isset($data[$index_to_delete])) {
            // İştirakçını massivdən silirik
            array_splice($data, $index_to_delete, 1);

            // Yenilənmiş məlumatları fayla yazırıq
            file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        }
    }
}

// Admin panelinə geri yönləndiririk
header("Location: admin_panel.php");
exit();
?>