<!DOCTYPE html>
<html lang="az">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Secret Santa İştirakçı Siyahısı</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <h1>İştirakçı Siyahısı</h1>
        <small class="note">Maksimal 50 AZN-ə qədər (müdirlər xaric)</small>
        <table>
            <thead>
                <tr>
                    <th>Ad</th>
                    <th>Soyad</th>
                    <th>Şirkət Adı</th>
                    <th>Hədiyyə İstəyi</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $file = 'data.json';
                if (file_exists($file)) {
                    $json_data = file_get_contents($file);
                    $data = json_decode($json_data, true);

                    if (!empty($data)) {
                        foreach ($data as $entry) {
                            echo "<tr>";
                            echo "<td>" . htmlspecialchars($entry['name']) . "</td>";
                            echo "<td>" . htmlspecialchars($entry['surname']) . "</td>";
                            echo "<td>" . htmlspecialchars($entry['company']) . "</td>";
                            echo "<td>" . htmlspecialchars($entry['wish']) . "</td>";
                            echo "</tr>";
                        }
                    } else {
                        echo "<tr><td colspan='4'>Heç bir iştirakçı qeydiyyatdan keçməyib.</td></tr>";
                    }
                } else {
                    echo "<tr><td colspan='4'>Heç bir iştirakçı qeydiyyatdan keçməyib.</td></tr>";
                }
                ?>
            </tbody>
        </table>
        <div class="view-list-link">
            <a href="index.html">Yeni Qeydiyyat</a>
        </div>
    </div>
    <audio id="background-music" src="music.mp3" loop></audio>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Music
            var music = document.getElementById('background-music');
            music.volume = 0.3; // Səs səviyyəsini tənzimləyin
            var promise = music.play();
            if (promise !== undefined) {
                promise.then(_ => {}).catch(error => {
                    document.body.addEventListener('click', () => music.play(), { once: true });
                });
            }
        });
    </script>
</body>
</html>